#ifndef __SATZILLA_GLOBAL_H__
#define __SATZILLA_GLOBAL_H__

#include "stopwatch.h"

namespace ubcsat { int main(int, char**); }
namespace varsat{double**  main(char* input, int& spsize, int timeout);}

extern double preTime;
extern int  OrigNumVars, OrigNumClauses;

extern Stopwatch gSW;
extern int gTimeOut;

static int preprocess=16;
static int cl_ZCHAFF=15;
#ifdef RANDOM_SATZILLA
#define LS_PREP_TIMEOUT "2"
static int satzillaType = 1;
static int top1_DEFAULT=10;
static int top2_DEFAULT=4;
static double FEAT_CUTOFF=120;
static int presolver1=14;
static int presolver2=9;
static int pretime1=30;
static int pretime2=30;
static bool doLobo=true;
static bool doDia=true;
static int solverSubset[]={1,2,8,10,11,12,13};
static int subsetSize=7;

static int FTFeatID1[]={2, 2, 1, 1, 1};
static int FTFeatID2[]={0, 2, 0, 2, 1};
static double FTModel[]={1.067737, 0.689905, 0.720074, -2.918108,
1.487766, 7.001865};
static double FTFeatMean[]={9577.283863, 268396422.040047,
1551.310954, 53208501.130742, 12540145.727915};
static double FTFeatStd[]={13299.638925, 802309750.579486,
3185.204864, 191952396.445175, 45845909.092251};
static int FTNumFeat = 5;

#else
 #ifdef CRAFTED_SATZILLA
 #define LS_PREP_TIMEOUT "2"
static int satzillaType = 2;
static int top1_DEFAULT=3;
static int top2_DEFAULT=9;
static double FEAT_CUTOFF=120;
static int presolver1=2;
static int presolver2=9;
static int pretime1=5;
static int pretime2=5;
static bool doLobo=true;
static bool doDia=true;
static int solverSubset[]={2,3,4,5,6,7,9};
static int subsetSize=7;

static int FTFeatID1[]={2, 2, 1, 1};
static int FTFeatID2[]={0, 2, 2, 0};
static double FTModel[]={4.347799, -1.073652, -1.596663, 1.718940, 8.314130};
static double FTFeatMean[]={51702.262082, 39072955763.076210,
1408837633.159851, 3380.676580};
static double FTFeatStd[]={190964.958908, 334245309465.802430,
14877845204.420614, 10295.805830};
static int FTNumFeat = 4;

 #else
 #define LS_PREP_TIMEOUT "2" 
static int satzillaType = 3;
static int top1_DEFAULT=9;
static int top2_DEFAULT=8;
static double FEAT_CUTOFF=120;
static int presolver1=9;
static int presolver2=8;
static int pretime1=10;
static int pretime2=5;
static bool doLobo=false;
static bool doDia=false;
static int solverSubset[]={2,3,6,8,9};
static int subsetSize=5;

static int FTFeatID1[]={1, 2};
static int FTFeatID2[]={1, 2};
static double FTModel[]={162.341117, 210.704352, 77.727531};
static double FTFeatMean[]={82857007291.119385, 5309989276456.511700};
static double FTFeatStd[]={495900297259.553220, 22762639436633.660000};
static int FTNumFeat = 2;
 #endif
#endif

#endif


