#include "crtanje.h"

int main( int argc, char **argv ) {
	Tacka A(-1.0,0.0), B(1.0,0.0), C(0.0,sqrt(3.0)); //formiramo tacke A,B,C
	Duz ab(A,B), ac(A,C), bc(B,C); //formiramo duzi AB, AC i BC

	//crtamo trougao ABC
	Nacrtaj( ab, red );
	Nacrtaj( bc, blue );
	Nacrtaj( ac, green );

	Tacka A1( (B.x+C.x)/2.0, (B.y+C.y)/2.0 ); 
	Tacka B1( (A.x+C.x)/2.0, (A.y+C.y)/2.0 ); 
	Tacka C1( (B.x+A.x)/2.0, (B.y+A.y)/2.0 ); 

	Tacka pravac_ta(A.x - A1.x, A.y - A1.y); //vektor AA1
	
	Duz tb( B,B1 ),tc( C,C1 ); 
	Prava ta( A1, pravac_ta ); //prava kroz tacku A1 ciji je pravac AA1

	Nacrtaj( ta, yellow ); //crtamo pravu
	Nacrtaj( tb, magenta );
	Nacrtaj( tc, white );

	Tacka T(0.0,sqrt(3.0)/3.0);

	Nacrtaj( T, violet ); //crtamo tacku

	float r = sqrt( (T.x - A1.x)*(T.x - A1.x) + (T.y - A1.y)*(T.y - A1.y) );
	float R = sqrt( (T.x - A.x)*(T.x - A.x) + (T.y - A.y)*(T.y - A.y) );

	Krug k1( T, r ), k2( T, R ); //formiramo krugove sa centrom u tacki T

	//crtamo krugove
	Nacrtaj( k1, black );  
	Nacrtaj( k2, orange );

	//prikazujemo citav crtez
	Prikazi( argc, argv );

	return 0;
}